const el = document.getElementById("tilt");
const btnContainer = document.getElementById("btnContainer");
const email = document.getElementById("email");
const password = document.getElementById("password");

const emailError = document.getElementById("emailError");
const passwordError = document.getElementById("passwordError");

let btnX = btnContainer.clientWidth / 2;
let btnY = btnContainer.clientHeight / 2;
const height = el.clientHeight;
const width = el.clientWidth;

function updateButtonPosition() {
  el.style.left = `${btnX - el.offsetWidth / 2}px`;
  el.style.top = `${btnY - el.offsetHeight / 2}px`;
}
updateButtonPosition();

// Function to toggle errors based on repel/tilt activation
function showErrors() {
  const emailEmpty = !email.value.trim();
  const passEmpty = !password.value.trim();

  if (emailEmpty) {
    emailError.style.display = "block";
    email.classList.add("error");
  } else {
    emailError.style.display = "none";
    email.classList.remove("error");
  }

  if (passEmpty) {
    passwordError.style.display = "block";
    password.classList.add("error");
  } else {
    passwordError.style.display = "none";
    password.classList.remove("error");
  }
}

function hideErrors() {
  emailError.style.display = "none";
  passwordError.style.display = "none";
  email.classList.remove("error");
  password.classList.remove("error");
}

btnContainer.addEventListener("mousemove", (e) => {
  const rect = btnContainer.getBoundingClientRect();
  const mouseX = e.clientX - rect.left;
  const mouseY = e.clientY - rect.top;
  const dx = mouseX - btnX;
  const dy = mouseY - btnY;
  const distance = Math.sqrt(dx * dx + dy * dy);

  const filled = email.value.trim() && password.value.trim();

  // Only show messages + borders when empty
  if (!filled) showErrors();
  else hideErrors();

  // REPEL MODE
  if (!filled && distance < 80) {
    const angle = Math.atan2(dy, dx);
    btnX += Math.cos(angle) * -40;
    btnY += Math.sin(angle) * -40;

    const halfW = el.offsetWidth / 2;
    const halfH = el.offsetHeight / 2;

    btnX = Math.max(halfW, Math.min(btnContainer.clientWidth - halfW, btnX));
    btnY = Math.max(halfH, Math.min(btnContainer.clientHeight - halfH, btnY));

    updateButtonPosition();
  }

  // TILT MODE: distance 20-60
  if (!filled && distance < 60 && distance > 20) {
    const yRotation = 60 * (dx / width);
    const xRotation = -60 * (dy / height);

    el.style.transform = `perspective(500px) rotateX(${xRotation}deg) rotateY(${yRotation}deg)`;
  } else {
    el.style.transform = "perspective(500px) rotateX(0) rotateY(0)";
  }
});

btnContainer.addEventListener("mouseleave", () => {
  el.style.transform = "perspective(500px) rotateX(0) rotateY(0)";
  hideErrors();
  resetButtonPosition();
});

function resetButtonPosition() {
  btnX = btnContainer.clientWidth / 2;
  btnY = btnContainer.clientHeight / 2;
  updateButtonPosition();
}
